<?php
/*--------------------------------------------------------------
   order_overview_performance.php 2023-04-14
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2023 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

/** @var DatabaseModel $this */
/** @var int $t_success */

if (!$this->indexExists('orders', 'INDEX', ['customers_status', 'customers_status_name'])) {
    $this->set_index('orders', 'INDEX', ['customers_status', 'customers_status_name'], 'customers_status_index');
}

if (!$this->indexExists('orders', 'INDEX', ['delivery_country_iso_code_2', 'delivery_country'])) {
    $this->set_index('orders', 'INDEX', ['delivery_country_iso_code_2', 'delivery_country'], 'delivery_country_index');
}

if (!$this->indexExists('orders', 'INDEX', ['shipping_class'])) {
    $this->set_index('orders', 'INDEX', ['shipping_class'], 'shipping_class');
}

if (!$this->indexExists('orders_status_history', 'INDEX', ['orders_status_id'])) {
    $this->set_index('orders_status_history', 'INDEX', ['orders_status_id'], 'orders_status_id');
}
